/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeDate
extends IdScriptableObject {
    static final long serialVersionUID = -8307438915861678966L;
    private static final Object DATE_TAG = "Date";
    private static final String js_NaN_date_str = "Invalid Date";
    private static final DateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final double HalfTimeDomain = 8.64E15;
    private static final double HoursPerDay = 24.0;
    private static final double MinutesPerHour = 60.0;
    private static final double SecondsPerMinute = 60.0;
    private static final double msPerSecond = 1000.0;
    private static final double MinutesPerDay = 1440.0;
    private static final double SecondsPerDay = 86400.0;
    private static final double SecondsPerHour = 3600.0;
    private static final double msPerDay = 8.64E7;
    private static final double msPerHour = 3600000.0;
    private static final double msPerMinute = 60000.0;
    private static final int MAXARGS = 7;
    private static final int ConstructorId_now = -3;
    private static final int ConstructorId_parse = -2;
    private static final int ConstructorId_UTC = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toTimeString = 3;
    private static final int Id_toDateString = 4;
    private static final int Id_toLocaleString = 5;
    private static final int Id_toLocaleTimeString = 6;
    private static final int Id_toLocaleDateString = 7;
    private static final int Id_toUTCString = 8;
    private static final int Id_toSource = 9;
    private static final int Id_valueOf = 10;
    private static final int Id_getTime = 11;
    private static final int Id_getYear = 12;
    private static final int Id_getFullYear = 13;
    private static final int Id_getUTCFullYear = 14;
    private static final int Id_getMonth = 15;
    private static final int Id_getUTCMonth = 16;
    private static final int Id_getDate = 17;
    private static final int Id_getUTCDate = 18;
    private static final int Id_getDay = 19;
    private static final int Id_getUTCDay = 20;
    private static final int Id_getHours = 21;
    private static final int Id_getUTCHours = 22;
    private static final int Id_getMinutes = 23;
    private static final int Id_getUTCMinutes = 24;
    private static final int Id_getSeconds = 25;
    private static final int Id_getUTCSeconds = 26;
    private static final int Id_getMilliseconds = 27;
    private static final int Id_getUTCMilliseconds = 28;
    private static final int Id_getTimezoneOffset = 29;
    private static final int Id_setTime = 30;
    private static final int Id_setMilliseconds = 31;
    private static final int Id_setUTCMilliseconds = 32;
    private static final int Id_setSeconds = 33;
    private static final int Id_setUTCSeconds = 34;
    private static final int Id_setMinutes = 35;
    private static final int Id_setUTCMinutes = 36;
    private static final int Id_setHours = 37;
    private static final int Id_setUTCHours = 38;
    private static final int Id_setDate = 39;
    private static final int Id_setUTCDate = 40;
    private static final int Id_setMonth = 41;
    private static final int Id_setUTCMonth = 42;
    private static final int Id_setFullYear = 43;
    private static final int Id_setUTCFullYear = 44;
    private static final int Id_setYear = 45;
    private static final int Id_toISOString = 46;
    private static final int Id_toJSON = 47;
    private static final int MAX_PROTOTYPE_ID = 47;
    private static final int Id_toGMTString = 8;
    private static TimeZone thisTimeZone;
    private static double LocalTZA;
    private static DateFormat timeZoneFormatter;
    private static DateFormat localeDateTimeFormatter;
    private static DateFormat localeDateFormatter;
    private static DateFormat localeTimeFormatter;
    private double date;

    static void init(Scriptable scope, boolean sealed) {
        NativeDate obj = new NativeDate();
        obj.date = ScriptRuntime.NaN;
        obj.exportAsJSClass(47, scope, sealed);
    }

    private NativeDate() {
        if (thisTimeZone == null) {
            thisTimeZone = TimeZone.getDefault();
            LocalTZA = thisTimeZone.getRawOffset();
        }
    }

    @Override
    public String getClassName() {
        return "Date";
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        if (typeHint == null) {
            typeHint = ScriptRuntime.StringClass;
        }
        return super.getDefaultValue(typeHint);
    }

    double getJSTimeValue() {
        return this.date;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, DATE_TAG, -3, "now", 0);
        this.addIdFunctionProperty(ctor, DATE_TAG, -2, "parse", 1);
        this.addIdFunctionProperty(ctor, DATE_TAG, -1, "UTC", 1);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s2 = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s2 = "toTimeString";
                break;
            }
            case 4: {
                arity = 0;
                s2 = "toDateString";
                break;
            }
            case 5: {
                arity = 0;
                s2 = "toLocaleString";
                break;
            }
            case 6: {
                arity = 0;
                s2 = "toLocaleTimeString";
                break;
            }
            case 7: {
                arity = 0;
                s2 = "toLocaleDateString";
                break;
            }
            case 8: {
                arity = 0;
                s2 = "toUTCString";
                break;
            }
            case 9: {
                arity = 0;
                s2 = "toSource";
                break;
            }
            case 10: {
                arity = 0;
                s2 = "valueOf";
                break;
            }
            case 11: {
                arity = 0;
                s2 = "getTime";
                break;
            }
            case 12: {
                arity = 0;
                s2 = "getYear";
                break;
            }
            case 13: {
                arity = 0;
                s2 = "getFullYear";
                break;
            }
            case 14: {
                arity = 0;
                s2 = "getUTCFullYear";
                break;
            }
            case 15: {
                arity = 0;
                s2 = "getMonth";
                break;
            }
            case 16: {
                arity = 0;
                s2 = "getUTCMonth";
                break;
            }
            case 17: {
                arity = 0;
                s2 = "getDate";
                break;
            }
            case 18: {
                arity = 0;
                s2 = "getUTCDate";
                break;
            }
            case 19: {
                arity = 0;
                s2 = "getDay";
                break;
            }
            case 20: {
                arity = 0;
                s2 = "getUTCDay";
                break;
            }
            case 21: {
                arity = 0;
                s2 = "getHours";
                break;
            }
            case 22: {
                arity = 0;
                s2 = "getUTCHours";
                break;
            }
            case 23: {
                arity = 0;
                s2 = "getMinutes";
                break;
            }
            case 24: {
                arity = 0;
                s2 = "getUTCMinutes";
                break;
            }
            case 25: {
                arity = 0;
                s2 = "getSeconds";
                break;
            }
            case 26: {
                arity = 0;
                s2 = "getUTCSeconds";
                break;
            }
            case 27: {
                arity = 0;
                s2 = "getMilliseconds";
                break;
            }
            case 28: {
                arity = 0;
                s2 = "getUTCMilliseconds";
                break;
            }
            case 29: {
                arity = 0;
                s2 = "getTimezoneOffset";
                break;
            }
            case 30: {
                arity = 1;
                s2 = "setTime";
                break;
            }
            case 31: {
                arity = 1;
                s2 = "setMilliseconds";
                break;
            }
            case 32: {
                arity = 1;
                s2 = "setUTCMilliseconds";
                break;
            }
            case 33: {
                arity = 2;
                s2 = "setSeconds";
                break;
            }
            case 34: {
                arity = 2;
                s2 = "setUTCSeconds";
                break;
            }
            case 35: {
                arity = 3;
                s2 = "setMinutes";
                break;
            }
            case 36: {
                arity = 3;
                s2 = "setUTCMinutes";
                break;
            }
            case 37: {
                arity = 4;
                s2 = "setHours";
                break;
            }
            case 38: {
                arity = 4;
                s2 = "setUTCHours";
                break;
            }
            case 39: {
                arity = 1;
                s2 = "setDate";
                break;
            }
            case 40: {
                arity = 1;
                s2 = "setUTCDate";
                break;
            }
            case 41: {
                arity = 2;
                s2 = "setMonth";
                break;
            }
            case 42: {
                arity = 2;
                s2 = "setUTCMonth";
                break;
            }
            case 43: {
                arity = 3;
                s2 = "setFullYear";
                break;
            }
            case 44: {
                arity = 3;
                s2 = "setUTCFullYear";
                break;
            }
            case 45: {
                arity = 1;
                s2 = "setYear";
                break;
            }
            case 46: {
                arity = 0;
                s2 = "toISOString";
                break;
            }
            case 47: {
                arity = 1;
                s2 = "toJSON";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(DATE_TAG, id, s2, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(DATE_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case -3: {
                return ScriptRuntime.wrapNumber(NativeDate.now());
            }
            case -2: {
                String dataStr = ScriptRuntime.toString(args2, 0);
                return ScriptRuntime.wrapNumber(NativeDate.date_parseString(dataStr));
            }
            case -1: {
                return ScriptRuntime.wrapNumber(NativeDate.jsStaticFunction_UTC(args2));
            }
            case 1: {
                if (thisObj != null) {
                    return NativeDate.date_format(NativeDate.now(), 2);
                }
                return NativeDate.jsConstructor(args2);
            }
            case 47: {
                double d;
                if (thisObj instanceof NativeDate) {
                    return ((NativeDate)thisObj).toISOString();
                }
                String toISOString = "toISOString";
                Scriptable o = ScriptRuntime.toObject(cx, scope, thisObj);
                Object tv = ScriptRuntime.toPrimitive(o, ScriptRuntime.NumberClass);
                if (tv instanceof Number && ((d = ((Number)tv).doubleValue()) != d || Double.isInfinite(d))) {
                    return null;
                }
                Object toISO = o.get("toISOString", o);
                if (toISO == NOT_FOUND) {
                    throw ScriptRuntime.typeError2("msg.function.not.found.in", "toISOString", ScriptRuntime.toString(o));
                }
                if (!(toISO instanceof Callable)) {
                    throw ScriptRuntime.typeError3("msg.isnt.function.in", "toISOString", ScriptRuntime.toString(o), ScriptRuntime.toString(toISO));
                }
                Object result2 = ((Callable)toISO).call(cx, scope, o, ScriptRuntime.emptyArgs);
                if (!ScriptRuntime.isPrimitive(result2)) {
                    throw ScriptRuntime.typeError1("msg.toisostring.must.return.primitive", ScriptRuntime.toString(result2));
                }
                return result2;
            }
        }
        if (!(thisObj instanceof NativeDate)) {
            throw NativeDate.incompatibleCallError(f2);
        }
        NativeDate realThis = (NativeDate)thisObj;
        double t = realThis.date;
        switch (id) {
            case 2: 
            case 3: 
            case 4: {
                if (t == t) {
                    return NativeDate.date_format(t, id);
                }
                return js_NaN_date_str;
            }
            case 5: 
            case 6: 
            case 7: {
                if (t == t) {
                    return NativeDate.toLocale_helper(t, id);
                }
                return js_NaN_date_str;
            }
            case 8: {
                if (t == t) {
                    return NativeDate.js_toUTCString(t);
                }
                return js_NaN_date_str;
            }
            case 9: {
                return "(new Date(" + ScriptRuntime.toString(t) + "))";
            }
            case 10: 
            case 11: {
                return ScriptRuntime.wrapNumber(t);
            }
            case 12: 
            case 13: 
            case 14: {
                if (t == t) {
                    if (id != 14) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.YearFromTime(t);
                    if (id == 12) {
                        if (cx.hasFeature(1)) {
                            if (1900.0 <= t && t < 2000.0) {
                                t -= 1900.0;
                            }
                        } else {
                            t -= 1900.0;
                        }
                    }
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 15: 
            case 16: {
                if (t == t) {
                    if (id == 15) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.MonthFromTime(t);
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 17: 
            case 18: {
                if (t == t) {
                    if (id == 17) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.DateFromTime(t);
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 19: 
            case 20: {
                if (t == t) {
                    if (id == 19) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.WeekDay(t);
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 21: 
            case 22: {
                if (t == t) {
                    if (id == 21) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.HourFromTime(t);
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 23: 
            case 24: {
                if (t == t) {
                    if (id == 23) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.MinFromTime(t);
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 25: 
            case 26: {
                if (t == t) {
                    if (id == 25) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.SecFromTime(t);
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 27: 
            case 28: {
                if (t == t) {
                    if (id == 27) {
                        t = NativeDate.LocalTime(t);
                    }
                    t = NativeDate.msFromTime(t);
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 29: {
                if (t == t) {
                    t = (t - NativeDate.LocalTime(t)) / 60000.0;
                }
                return ScriptRuntime.wrapNumber(t);
            }
            case 30: {
                realThis.date = t = NativeDate.TimeClip(ScriptRuntime.toNumber(args2, 0));
                return ScriptRuntime.wrapNumber(t);
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                realThis.date = t = NativeDate.makeTime(t, args2, id);
                return ScriptRuntime.wrapNumber(t);
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                realThis.date = t = NativeDate.makeDate(t, args2, id);
                return ScriptRuntime.wrapNumber(t);
            }
            case 45: {
                double year = ScriptRuntime.toNumber(args2, 0);
                if (year != year || Double.isInfinite(year)) {
                    t = ScriptRuntime.NaN;
                } else {
                    t = t != t ? 0.0 : NativeDate.LocalTime(t);
                    if (year >= 0.0 && year <= 99.0) {
                        year += 1900.0;
                    }
                    double day = NativeDate.MakeDay(year, NativeDate.MonthFromTime(t), NativeDate.DateFromTime(t));
                    t = NativeDate.MakeDate(day, NativeDate.TimeWithinDay(t));
                    t = NativeDate.internalUTC(t);
                    t = NativeDate.TimeClip(t);
                }
                realThis.date = t;
                return ScriptRuntime.wrapNumber(t);
            }
            case 46: {
                return realThis.toISOString();
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toISOString() {
        if (this.date == this.date) {
            DateFormat dateFormat = isoFormat;
            synchronized (dateFormat) {
                return isoFormat.format(new Date((long)this.date));
            }
        }
        String msg = ScriptRuntime.getMessage0("msg.invalid.date");
        throw ScriptRuntime.constructError("RangeError", msg);
    }

    private static double Day(double t) {
        return Math.floor(t / 8.64E7);
    }

    private static double TimeWithinDay(double t) {
        double result2 = t % 8.64E7;
        if (result2 < 0.0) {
            result2 += 8.64E7;
        }
        return result2;
    }

    private static boolean IsLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static double DayFromYear(double y) {
        return 365.0 * (y - 1970.0) + Math.floor((y - 1969.0) / 4.0) - Math.floor((y - 1901.0) / 100.0) + Math.floor((y - 1601.0) / 400.0);
    }

    private static double TimeFromYear(double y) {
        return NativeDate.DayFromYear(y) * 8.64E7;
    }

    private static int YearFromTime(double t) {
        int lo2 = (int)Math.floor(t / 8.64E7 / 366.0) + 1970;
        int hi2 = (int)Math.floor(t / 8.64E7 / 365.0) + 1970;
        if (hi2 < lo2) {
            int temp = lo2;
            lo2 = hi2;
            hi2 = temp;
        }
        while (hi2 > lo2) {
            int mid = (hi2 + lo2) / 2;
            if (NativeDate.TimeFromYear(mid) > t) {
                hi2 = mid - 1;
                continue;
            }
            lo2 = mid + 1;
            if (!(NativeDate.TimeFromYear(lo2) > t)) continue;
            return mid;
        }
        return lo2;
    }

    private static double DayFromMonth(int m, int year) {
        int day = m * 30;
        day = m >= 7 ? (day += m / 2 - 1) : (m >= 2 ? (day += (m - 1) / 2 - 1) : (day += m));
        if (m >= 2 && NativeDate.IsLeapYear(year)) {
            ++day;
        }
        return day;
    }

    private static int MonthFromTime(double t) {
        int mstart;
        int year = NativeDate.YearFromTime(t);
        int d = (int)(NativeDate.Day(t) - NativeDate.DayFromYear(year));
        if ((d -= 59) < 0) {
            return d < -28 ? 0 : 1;
        }
        if (NativeDate.IsLeapYear(year)) {
            if (d == 0) {
                return 1;
            }
            --d;
        }
        int estimate = d / 30;
        switch (estimate) {
            case 0: {
                return 2;
            }
            case 1: {
                mstart = 31;
                break;
            }
            case 2: {
                mstart = 61;
                break;
            }
            case 3: {
                mstart = 92;
                break;
            }
            case 4: {
                mstart = 122;
                break;
            }
            case 5: {
                mstart = 153;
                break;
            }
            case 6: {
                mstart = 184;
                break;
            }
            case 7: {
                mstart = 214;
                break;
            }
            case 8: {
                mstart = 245;
                break;
            }
            case 9: {
                mstart = 275;
                break;
            }
            case 10: {
                return 11;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        return d >= mstart ? estimate + 2 : estimate + 1;
    }

    private static int DateFromTime(double t) {
        int mstart;
        int mdays;
        int year = NativeDate.YearFromTime(t);
        int d = (int)(NativeDate.Day(t) - NativeDate.DayFromYear(year));
        if ((d -= 59) < 0) {
            return d < -28 ? d + 31 + 28 + 1 : d + 28 + 1;
        }
        if (NativeDate.IsLeapYear(year)) {
            if (d == 0) {
                return 29;
            }
            --d;
        }
        switch (d / 30) {
            case 0: {
                return d + 1;
            }
            case 1: {
                mdays = 31;
                mstart = 31;
                break;
            }
            case 2: {
                mdays = 30;
                mstart = 61;
                break;
            }
            case 3: {
                mdays = 31;
                mstart = 92;
                break;
            }
            case 4: {
                mdays = 30;
                mstart = 122;
                break;
            }
            case 5: {
                mdays = 31;
                mstart = 153;
                break;
            }
            case 6: {
                mdays = 31;
                mstart = 184;
                break;
            }
            case 7: {
                mdays = 30;
                mstart = 214;
                break;
            }
            case 8: {
                mdays = 31;
                mstart = 245;
                break;
            }
            case 9: {
                mdays = 30;
                mstart = 275;
                break;
            }
            case 10: {
                return d - 275 + 1;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        if ((d -= mstart) < 0) {
            d += mdays;
        }
        return d + 1;
    }

    private static int WeekDay(double t) {
        double result2 = NativeDate.Day(t) + 4.0;
        if ((result2 %= 7.0) < 0.0) {
            result2 += 7.0;
        }
        return (int)result2;
    }

    private static double now() {
        return System.currentTimeMillis();
    }

    private static double DaylightSavingTA(double t) {
        Date date;
        if (t < 0.0) {
            int year = NativeDate.EquivalentYear(NativeDate.YearFromTime(t));
            double day = NativeDate.MakeDay(year, NativeDate.MonthFromTime(t), NativeDate.DateFromTime(t));
            t = NativeDate.MakeDate(day, NativeDate.TimeWithinDay(t));
        }
        if (thisTimeZone.inDaylightTime(date = new Date((long)t))) {
            return 3600000.0;
        }
        return 0.0;
    }

    private static int EquivalentYear(int year) {
        int day = (int)NativeDate.DayFromYear(year) + 4;
        if ((day %= 7) < 0) {
            day += 7;
        }
        if (NativeDate.IsLeapYear(year)) {
            switch (day) {
                case 0: {
                    return 1984;
                }
                case 1: {
                    return 1996;
                }
                case 2: {
                    return 1980;
                }
                case 3: {
                    return 1992;
                }
                case 4: {
                    return 1976;
                }
                case 5: {
                    return 1988;
                }
                case 6: {
                    return 1972;
                }
            }
        } else {
            switch (day) {
                case 0: {
                    return 1978;
                }
                case 1: {
                    return 1973;
                }
                case 2: {
                    return 1985;
                }
                case 3: {
                    return 1986;
                }
                case 4: {
                    return 1981;
                }
                case 5: {
                    return 1971;
                }
                case 6: {
                    return 1977;
                }
            }
        }
        throw Kit.codeBug();
    }

    private static double LocalTime(double t) {
        return t + LocalTZA + NativeDate.DaylightSavingTA(t);
    }

    private static double internalUTC(double t) {
        return t - LocalTZA - NativeDate.DaylightSavingTA(t - LocalTZA);
    }

    private static int HourFromTime(double t) {
        double result2 = Math.floor(t / 3600000.0) % 24.0;
        if (result2 < 0.0) {
            result2 += 24.0;
        }
        return (int)result2;
    }

    private static int MinFromTime(double t) {
        double result2 = Math.floor(t / 60000.0) % 60.0;
        if (result2 < 0.0) {
            result2 += 60.0;
        }
        return (int)result2;
    }

    private static int SecFromTime(double t) {
        double result2 = Math.floor(t / 1000.0) % 60.0;
        if (result2 < 0.0) {
            result2 += 60.0;
        }
        return (int)result2;
    }

    private static int msFromTime(double t) {
        double result2 = t % 1000.0;
        if (result2 < 0.0) {
            result2 += 1000.0;
        }
        return (int)result2;
    }

    private static double MakeTime(double hour, double min2, double sec, double ms) {
        return ((hour * 60.0 + min2) * 60.0 + sec) * 1000.0 + ms;
    }

    private static double MakeDay(double year, double month, double date) {
        year += Math.floor(month / 12.0);
        if ((month %= 12.0) < 0.0) {
            month += 12.0;
        }
        double yearday = Math.floor(NativeDate.TimeFromYear(year) / 8.64E7);
        double monthday = NativeDate.DayFromMonth((int)month, (int)year);
        return yearday + monthday + date - 1.0;
    }

    private static double MakeDate(double day, double time) {
        return day * 8.64E7 + time;
    }

    private static double TimeClip(double d) {
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Math.abs(d) > 8.64E15) {
            return ScriptRuntime.NaN;
        }
        if (d > 0.0) {
            return Math.floor(d + 0.0);
        }
        return Math.ceil(d + 0.0);
    }

    private static double date_msecFromDate(double year, double mon, double mday, double hour, double min2, double sec, double msec) {
        double day = NativeDate.MakeDay(year, mon, mday);
        double time = NativeDate.MakeTime(hour, min2, sec, msec);
        double result2 = NativeDate.MakeDate(day, time);
        return result2;
    }

    private static double date_msecFromArgs(Object[] args2) {
        double[] array = new double[7];
        for (int loop2 = 0; loop2 < 7; ++loop2) {
            if (loop2 < args2.length) {
                double d = ScriptRuntime.toNumber(args2[loop2]);
                if (d != d || Double.isInfinite(d)) {
                    return ScriptRuntime.NaN;
                }
                array[loop2] = ScriptRuntime.toInteger(args2[loop2]);
                continue;
            }
            array[loop2] = loop2 == 2 ? 1.0 : 0.0;
        }
        if (array[0] >= 0.0 && array[0] <= 99.0) {
            array[0] = array[0] + 1900.0;
        }
        return NativeDate.date_msecFromDate(array[0], array[1], array[2], array[3], array[4], array[5], array[6]);
    }

    private static double jsStaticFunction_UTC(Object[] args2) {
        return NativeDate.TimeClip(NativeDate.date_msecFromArgs(args2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double date_parseString(String s2) {
        block60: {
            try {
                if (s2.length() != 24) break block60;
                DateFormat dateFormat = isoFormat;
                synchronized (dateFormat) {
                    Date d = isoFormat.parse(s2);
                    return d.getTime();
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        int year = -1;
        int mon = -1;
        int mday = -1;
        int hour = -1;
        int min2 = -1;
        int sec = -1;
        char c = '\u0000';
        char si = '\u0000';
        int i = 0;
        int n = -1;
        double tzoffset = -1.0;
        char prevc = '\u0000';
        int limit = 0;
        boolean seenplusminus = false;
        limit = s2.length();
        block18: while (i < limit) {
            c = s2.charAt(i);
            ++i;
            if (c <= ' ' || c == ',' || c == '-') {
                if (i >= limit) continue;
                si = s2.charAt(i);
                if (c != '-' || '0' > si || si > '9') continue;
                prevc = c;
                continue;
            }
            if (c == '(') {
                int depth = 1;
                while (i < limit) {
                    c = s2.charAt(i);
                    ++i;
                    if (c == '(') {
                        ++depth;
                        continue;
                    }
                    if (c != ')' || --depth > 0) continue;
                    continue block18;
                }
                continue;
            }
            if ('0' <= c && c <= '9') {
                n = c - 48;
                while (i < limit && '0' <= (c = s2.charAt(i)) && c <= '9') {
                    n = n * 10 + c - 48;
                    ++i;
                }
                if (prevc == '+' || prevc == '-') {
                    seenplusminus = true;
                    n = n < 24 ? (n *= 60) : n % 100 + n / 100 * 60;
                    if (prevc == '+') {
                        n = -n;
                    }
                    if (tzoffset != 0.0 && tzoffset != -1.0) {
                        return ScriptRuntime.NaN;
                    }
                    tzoffset = n;
                } else if (n >= 70 || prevc == '/' && mon >= 0 && mday >= 0 && year < 0) {
                    if (year >= 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (c > ' ' && c != ',' && c != '/' && i < limit) return ScriptRuntime.NaN;
                    year = n < 100 ? n + 1900 : n;
                } else if (c == ':') {
                    if (hour < 0) {
                        hour = n;
                    } else {
                        if (min2 >= 0) return ScriptRuntime.NaN;
                        min2 = n;
                    }
                } else if (c == '/') {
                    if (mon < 0) {
                        mon = n - 1;
                    } else {
                        if (mday >= 0) return ScriptRuntime.NaN;
                        mday = n;
                    }
                } else {
                    if (i < limit && c != ',' && c > ' ' && c != '-') {
                        return ScriptRuntime.NaN;
                    }
                    if (seenplusminus && n < 60) {
                        tzoffset = tzoffset < 0.0 ? (tzoffset -= (double)n) : (tzoffset += (double)n);
                    } else if (hour >= 0 && min2 < 0) {
                        min2 = n;
                    } else if (min2 >= 0 && sec < 0) {
                        sec = n;
                    } else {
                        if (mday >= 0) return ScriptRuntime.NaN;
                        mday = n;
                    }
                }
                prevc = '\u0000';
                continue;
            }
            if (c == '/' || c == ':' || c == '+' || c == '-') {
                prevc = c;
                continue;
            }
            int st = i - 1;
            while (i < limit && ('A' <= (c = s2.charAt(i)) && c <= 'Z' || 'a' <= c && c <= 'z')) {
                ++i;
            }
            int letterCount = i - st;
            if (letterCount < 2) {
                return ScriptRuntime.NaN;
            }
            String wtb = "am;pm;monday;tuesday;wednesday;thursday;friday;saturday;sunday;january;february;march;april;may;june;july;august;september;october;november;december;gmt;ut;utc;est;edt;cst;cdt;mst;mdt;pst;pdt;";
            int index2 = 0;
            int wtbOffset = 0;
            while (true) {
                int wtbNext;
                if ((wtbNext = wtb.indexOf(59, wtbOffset)) < 0) {
                    return ScriptRuntime.NaN;
                }
                if (wtb.regionMatches(true, wtbOffset, s2, st, letterCount)) break;
                wtbOffset = wtbNext + 1;
                ++index2;
            }
            if (index2 < 2) {
                if (hour > 12 || hour < 0) {
                    return ScriptRuntime.NaN;
                }
                if (index2 == 0) {
                    if (hour != 12) continue;
                    hour = 0;
                    continue;
                }
                if (hour == 12) continue;
                hour += 12;
                continue;
            }
            if ((index2 -= 2) < 7) continue;
            if ((index2 -= 7) < 12) {
                if (mon >= 0) return ScriptRuntime.NaN;
                mon = index2;
                continue;
            }
            switch (index2 -= 12) {
                case 0: {
                    tzoffset = 0.0;
                    continue block18;
                }
                case 1: {
                    tzoffset = 0.0;
                    continue block18;
                }
                case 2: {
                    tzoffset = 0.0;
                    continue block18;
                }
                case 3: {
                    tzoffset = 300.0;
                    continue block18;
                }
                case 4: {
                    tzoffset = 240.0;
                    continue block18;
                }
                case 5: {
                    tzoffset = 360.0;
                    continue block18;
                }
                case 6: {
                    tzoffset = 300.0;
                    continue block18;
                }
                case 7: {
                    tzoffset = 420.0;
                    continue block18;
                }
                case 8: {
                    tzoffset = 360.0;
                    continue block18;
                }
                case 9: {
                    tzoffset = 480.0;
                    continue block18;
                }
                case 10: {
                    tzoffset = 420.0;
                    continue block18;
                }
            }
            Kit.codeBug();
        }
        if (year < 0 || mon < 0 || mday < 0) {
            return ScriptRuntime.NaN;
        }
        if (sec < 0) {
            sec = 0;
        }
        if (min2 < 0) {
            min2 = 0;
        }
        if (hour < 0) {
            hour = 0;
        }
        double msec = NativeDate.date_msecFromDate(year, mon, mday, hour, min2, sec, 0.0);
        if (tzoffset != -1.0) return msec + tzoffset * 60000.0;
        return NativeDate.internalUTC(msec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String date_format(double t, int methodId) {
        StringBuffer result2 = new StringBuffer(60);
        double local = NativeDate.LocalTime(t);
        if (methodId != 3) {
            NativeDate.appendWeekDayName(result2, NativeDate.WeekDay(local));
            result2.append(' ');
            NativeDate.appendMonthName(result2, NativeDate.MonthFromTime(local));
            result2.append(' ');
            NativeDate.append0PaddedUint(result2, NativeDate.DateFromTime(local), 2);
            result2.append(' ');
            int year = NativeDate.YearFromTime(local);
            if (year < 0) {
                result2.append('-');
                year = -year;
            }
            NativeDate.append0PaddedUint(result2, year, 4);
            if (methodId != 4) {
                result2.append(' ');
            }
        }
        if (methodId != 4) {
            NativeDate.append0PaddedUint(result2, NativeDate.HourFromTime(local), 2);
            result2.append(':');
            NativeDate.append0PaddedUint(result2, NativeDate.MinFromTime(local), 2);
            result2.append(':');
            NativeDate.append0PaddedUint(result2, NativeDate.SecFromTime(local), 2);
            int minutes = (int)Math.floor((LocalTZA + NativeDate.DaylightSavingTA(t)) / 60000.0);
            int offset = minutes / 60 * 100 + minutes % 60;
            if (offset > 0) {
                result2.append(" GMT+");
            } else {
                result2.append(" GMT-");
                offset = -offset;
            }
            NativeDate.append0PaddedUint(result2, offset, 4);
            if (timeZoneFormatter == null) {
                timeZoneFormatter = new SimpleDateFormat("zzz");
            }
            if (t < 0.0) {
                int equiv = NativeDate.EquivalentYear(NativeDate.YearFromTime(local));
                double day = NativeDate.MakeDay(equiv, NativeDate.MonthFromTime(t), NativeDate.DateFromTime(t));
                t = NativeDate.MakeDate(day, NativeDate.TimeWithinDay(t));
            }
            result2.append(" (");
            Date date = new Date((long)t);
            DateFormat dateFormat = timeZoneFormatter;
            synchronized (dateFormat) {
                result2.append(timeZoneFormatter.format(date));
            }
            result2.append(')');
        }
        return result2.toString();
    }

    private static Object jsConstructor(Object[] args2) {
        NativeDate obj = new NativeDate();
        if (args2.length == 0) {
            obj.date = NativeDate.now();
            return obj;
        }
        if (args2.length == 1) {
            Object arg0 = args2[0];
            if (arg0 instanceof Scriptable) {
                arg0 = ((Scriptable)arg0).getDefaultValue(null);
            }
            double date = arg0 instanceof CharSequence ? NativeDate.date_parseString(arg0.toString()) : ScriptRuntime.toNumber(arg0);
            obj.date = NativeDate.TimeClip(date);
            return obj;
        }
        double time = NativeDate.date_msecFromArgs(args2);
        if (!Double.isNaN(time) && !Double.isInfinite(time)) {
            time = NativeDate.TimeClip(NativeDate.internalUTC(time));
        }
        obj.date = time;
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toLocale_helper(double t, int methodId) {
        DateFormat formatter;
        switch (methodId) {
            case 5: {
                if (localeDateTimeFormatter == null) {
                    localeDateTimeFormatter = DateFormat.getDateTimeInstance(1, 1);
                }
                formatter = localeDateTimeFormatter;
                break;
            }
            case 6: {
                if (localeTimeFormatter == null) {
                    localeTimeFormatter = DateFormat.getTimeInstance(1);
                }
                formatter = localeTimeFormatter;
                break;
            }
            case 7: {
                if (localeDateFormatter == null) {
                    localeDateFormatter = DateFormat.getDateInstance(1);
                }
                formatter = localeDateFormatter;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        DateFormat dateFormat = formatter;
        synchronized (dateFormat) {
            return formatter.format(new Date((long)t));
        }
    }

    private static String js_toUTCString(double date) {
        StringBuffer result2 = new StringBuffer(60);
        NativeDate.appendWeekDayName(result2, NativeDate.WeekDay(date));
        result2.append(", ");
        NativeDate.append0PaddedUint(result2, NativeDate.DateFromTime(date), 2);
        result2.append(' ');
        NativeDate.appendMonthName(result2, NativeDate.MonthFromTime(date));
        result2.append(' ');
        int year = NativeDate.YearFromTime(date);
        if (year < 0) {
            result2.append('-');
            year = -year;
        }
        NativeDate.append0PaddedUint(result2, year, 4);
        result2.append(' ');
        NativeDate.append0PaddedUint(result2, NativeDate.HourFromTime(date), 2);
        result2.append(':');
        NativeDate.append0PaddedUint(result2, NativeDate.MinFromTime(date), 2);
        result2.append(':');
        NativeDate.append0PaddedUint(result2, NativeDate.SecFromTime(date), 2);
        result2.append(" GMT");
        return result2.toString();
    }

    private static void append0PaddedUint(StringBuffer sb, int i, int minWidth) {
        if (i < 0) {
            Kit.codeBug();
        }
        int scale = 1;
        --minWidth;
        if (i >= 10) {
            if (i < 1000000000) {
                int newScale;
                while (i >= (newScale = scale * 10)) {
                    --minWidth;
                    scale = newScale;
                }
            } else {
                minWidth -= 9;
                scale = 1000000000;
            }
        }
        while (minWidth > 0) {
            sb.append('0');
            --minWidth;
        }
        while (scale != 1) {
            sb.append((char)(48 + i / scale));
            i %= scale;
            scale /= 10;
        }
        sb.append((char)(48 + i));
    }

    private static void appendMonthName(StringBuffer sb, int index2) {
        String months = "JanFebMarAprMayJunJulAugSepOctNovDec";
        index2 *= 3;
        for (int i = 0; i != 3; ++i) {
            sb.append(months.charAt(index2 + i));
        }
    }

    private static void appendWeekDayName(StringBuffer sb, int index2) {
        String days = "SunMonTueWedThuFriSat";
        index2 *= 3;
        for (int i = 0; i != 3; ++i) {
            sb.append(days.charAt(index2 + i));
        }
    }

    private static double makeTime(double date, Object[] args2, int methodId) {
        int i;
        int maxargs;
        boolean local = true;
        switch (methodId) {
            case 32: {
                local = false;
            }
            case 31: {
                maxargs = 1;
                break;
            }
            case 34: {
                local = false;
            }
            case 33: {
                maxargs = 2;
                break;
            }
            case 36: {
                local = false;
            }
            case 35: {
                maxargs = 3;
                break;
            }
            case 38: {
                local = false;
            }
            case 37: {
                maxargs = 4;
                break;
            }
            default: {
                Kit.codeBug();
                maxargs = 0;
            }
        }
        double[] conv = new double[4];
        if (date != date) {
            return date;
        }
        if (args2.length == 0) {
            args2 = ScriptRuntime.padArguments(args2, 1);
        }
        for (i = 0; i < args2.length && i < maxargs; ++i) {
            conv[i] = ScriptRuntime.toNumber(args2[i]);
            if (conv[i] != conv[i] || Double.isInfinite(conv[i])) {
                return ScriptRuntime.NaN;
            }
            conv[i] = ScriptRuntime.toInteger(conv[i]);
        }
        double lorutime = local ? NativeDate.LocalTime(date) : date;
        i = 0;
        int stop = args2.length;
        double hour = maxargs >= 4 && i < stop ? conv[i++] : (double)NativeDate.HourFromTime(lorutime);
        double min2 = maxargs >= 3 && i < stop ? conv[i++] : (double)NativeDate.MinFromTime(lorutime);
        double sec = maxargs >= 2 && i < stop ? conv[i++] : (double)NativeDate.SecFromTime(lorutime);
        double msec = maxargs >= 1 && i < stop ? conv[i++] : (double)NativeDate.msFromTime(lorutime);
        double time = NativeDate.MakeTime(hour, min2, sec, msec);
        double result2 = NativeDate.MakeDate(NativeDate.Day(lorutime), time);
        if (local) {
            result2 = NativeDate.internalUTC(result2);
        }
        date = NativeDate.TimeClip(result2);
        return date;
    }

    private static double makeDate(double date, Object[] args2, int methodId) {
        double lorutime;
        int i;
        int maxargs;
        boolean local = true;
        switch (methodId) {
            case 40: {
                local = false;
            }
            case 39: {
                maxargs = 1;
                break;
            }
            case 42: {
                local = false;
            }
            case 41: {
                maxargs = 2;
                break;
            }
            case 44: {
                local = false;
            }
            case 43: {
                maxargs = 3;
                break;
            }
            default: {
                Kit.codeBug();
                maxargs = 0;
            }
        }
        double[] conv = new double[3];
        if (args2.length == 0) {
            args2 = ScriptRuntime.padArguments(args2, 1);
        }
        for (i = 0; i < args2.length && i < maxargs; ++i) {
            conv[i] = ScriptRuntime.toNumber(args2[i]);
            if (conv[i] != conv[i] || Double.isInfinite(conv[i])) {
                return ScriptRuntime.NaN;
            }
            conv[i] = ScriptRuntime.toInteger(conv[i]);
        }
        if (date != date) {
            if (args2.length < 3) {
                return ScriptRuntime.NaN;
            }
            lorutime = 0.0;
        } else {
            lorutime = local ? NativeDate.LocalTime(date) : date;
        }
        i = 0;
        int stop = args2.length;
        double year = maxargs >= 3 && i < stop ? conv[i++] : (double)NativeDate.YearFromTime(lorutime);
        double month = maxargs >= 2 && i < stop ? conv[i++] : (double)NativeDate.MonthFromTime(lorutime);
        double day = maxargs >= 1 && i < stop ? conv[i++] : (double)NativeDate.DateFromTime(lorutime);
        day = NativeDate.MakeDay(year, month, day);
        double result2 = NativeDate.MakeDate(day, NativeDate.TimeWithinDay(lorutime));
        if (local) {
            result2 = NativeDate.internalUTC(result2);
        }
        date = NativeDate.TimeClip(result2);
        return date;
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block59: {
            id = 0;
            String X = null;
            block0 : switch (s2.length()) {
                case 6: {
                    char c = s2.charAt(0);
                    if (c == 'g') {
                        X = "getDay";
                        id = 19;
                        break;
                    }
                    if (c != 't') break;
                    X = "toJSON";
                    id = 47;
                    break;
                }
                case 7: {
                    switch (s2.charAt(3)) {
                        case 'D': {
                            char c = s2.charAt(0);
                            if (c == 'g') {
                                X = "getDate";
                                id = 17;
                                break block0;
                            }
                            if (c != 's') break block0;
                            X = "setDate";
                            id = 39;
                            break block0;
                        }
                        case 'T': {
                            char c = s2.charAt(0);
                            if (c == 'g') {
                                X = "getTime";
                                id = 11;
                                break block0;
                            }
                            if (c != 's') break block0;
                            X = "setTime";
                            id = 30;
                            break block0;
                        }
                        case 'Y': {
                            char c = s2.charAt(0);
                            if (c == 'g') {
                                X = "getYear";
                                id = 12;
                                break block0;
                            }
                            if (c != 's') break block0;
                            X = "setYear";
                            id = 45;
                            break block0;
                        }
                        case 'u': {
                            X = "valueOf";
                            id = 10;
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (s2.charAt(3)) {
                        case 'H': {
                            char c = s2.charAt(0);
                            if (c == 'g') {
                                X = "getHours";
                                id = 21;
                                break block0;
                            }
                            if (c != 's') break block0;
                            X = "setHours";
                            id = 37;
                            break block0;
                        }
                        case 'M': {
                            char c = s2.charAt(0);
                            if (c == 'g') {
                                X = "getMonth";
                                id = 15;
                                break block0;
                            }
                            if (c != 's') break block0;
                            X = "setMonth";
                            id = 41;
                            break block0;
                        }
                        case 'o': {
                            X = "toSource";
                            id = 9;
                            break block0;
                        }
                        case 't': {
                            X = "toString";
                            id = 2;
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    X = "getUTCDay";
                    id = 20;
                    break;
                }
                case 10: {
                    char c = s2.charAt(3);
                    if (c == 'M') {
                        c = s2.charAt(0);
                        if (c == 'g') {
                            X = "getMinutes";
                            id = 23;
                            break;
                        }
                        if (c != 's') break;
                        X = "setMinutes";
                        id = 35;
                        break;
                    }
                    if (c == 'S') {
                        c = s2.charAt(0);
                        if (c == 'g') {
                            X = "getSeconds";
                            id = 25;
                            break;
                        }
                        if (c != 's') break;
                        X = "setSeconds";
                        id = 33;
                        break;
                    }
                    if (c != 'U') break;
                    c = s2.charAt(0);
                    if (c == 'g') {
                        X = "getUTCDate";
                        id = 18;
                        break;
                    }
                    if (c != 's') break;
                    X = "setUTCDate";
                    id = 40;
                    break;
                }
                case 11: {
                    switch (s2.charAt(3)) {
                        case 'F': {
                            char c = s2.charAt(0);
                            if (c == 'g') {
                                X = "getFullYear";
                                id = 13;
                                break block0;
                            }
                            if (c != 's') break block0;
                            X = "setFullYear";
                            id = 43;
                            break block0;
                        }
                        case 'M': {
                            X = "toGMTString";
                            id = 8;
                            break block0;
                        }
                        case 'S': {
                            X = "toISOString";
                            id = 46;
                            break block0;
                        }
                        case 'T': {
                            X = "toUTCString";
                            id = 8;
                            break block0;
                        }
                        case 'U': {
                            char c = s2.charAt(0);
                            if (c == 'g') {
                                c = s2.charAt(9);
                                if (c == 'r') {
                                    X = "getUTCHours";
                                    id = 22;
                                    break block0;
                                }
                                if (c != 't') break block0;
                                X = "getUTCMonth";
                                id = 16;
                                break block0;
                            }
                            if (c != 's') break block0;
                            c = s2.charAt(9);
                            if (c == 'r') {
                                X = "setUTCHours";
                                id = 38;
                                break block0;
                            }
                            if (c != 't') break block0;
                            X = "setUTCMonth";
                            id = 42;
                            break block0;
                        }
                        case 's': {
                            X = "constructor";
                            id = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case 12: {
                    char c = s2.charAt(2);
                    if (c == 'D') {
                        X = "toDateString";
                        id = 4;
                        break;
                    }
                    if (c != 'T') break;
                    X = "toTimeString";
                    id = 3;
                    break;
                }
                case 13: {
                    char c = s2.charAt(0);
                    if (c == 'g') {
                        c = s2.charAt(6);
                        if (c == 'M') {
                            X = "getUTCMinutes";
                            id = 24;
                            break;
                        }
                        if (c != 'S') break;
                        X = "getUTCSeconds";
                        id = 26;
                        break;
                    }
                    if (c != 's') break;
                    c = s2.charAt(6);
                    if (c == 'M') {
                        X = "setUTCMinutes";
                        id = 36;
                        break;
                    }
                    if (c != 'S') break;
                    X = "setUTCSeconds";
                    id = 34;
                    break;
                }
                case 14: {
                    char c = s2.charAt(0);
                    if (c == 'g') {
                        X = "getUTCFullYear";
                        id = 14;
                        break;
                    }
                    if (c == 's') {
                        X = "setUTCFullYear";
                        id = 44;
                        break;
                    }
                    if (c != 't') break;
                    X = "toLocaleString";
                    id = 5;
                    break;
                }
                case 15: {
                    char c = s2.charAt(0);
                    if (c == 'g') {
                        X = "getMilliseconds";
                        id = 27;
                        break;
                    }
                    if (c != 's') break;
                    X = "setMilliseconds";
                    id = 31;
                    break;
                }
                case 17: {
                    X = "getTimezoneOffset";
                    id = 29;
                    break;
                }
                case 18: {
                    char c = s2.charAt(0);
                    if (c == 'g') {
                        X = "getUTCMilliseconds";
                        id = 28;
                        break;
                    }
                    if (c == 's') {
                        X = "setUTCMilliseconds";
                        id = 32;
                        break;
                    }
                    if (c != 't') break;
                    c = s2.charAt(8);
                    if (c == 'D') {
                        X = "toLocaleDateString";
                        id = 7;
                        break;
                    }
                    if (c != 'T') break;
                    X = "toLocaleTimeString";
                    id = 6;
                    break;
                }
            }
            if (X == null || X == s2 || X.equals(s2)) break block59;
            id = 0;
        }
        return id;
    }

    static {
        isoFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        isoFormat.setLenient(false);
    }
}

